using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    public struct Tacka
    {
        public long x, y;
        public Tacka(long x, long y) { this.x = x; this.y = y; }
    }
    public class UporediTacke : IComparer<Tacka>
    {
        public int Compare(Tacka t1, Tacka t2)
        {
            int xUporedi = t1.x.CompareTo(t2.x);
            if (xUporedi != 0)
            {
                return xUporedi;
            }
            return t1.y.CompareTo(t2.y);
        }
    }
    public static long Proizvod(Tacka a, Tacka b, Tacka c)
    {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    }
    public static long MnogougaoP(List<Tacka> tacke)
    {
        long povrsina = 0;
        int n = tacke.Count;
        for (int i = 0; i < n; i++)
        {
            int a = (i + 1) % n;
            povrsina += tacke[i].x * tacke[a].y;
            povrsina -= tacke[i].y * tacke[a].x;
        }
        return Math.Abs(povrsina) / 2;
    }
    public static List<Tacka> Omotac(List<Tacka> tacke)
    {
        tacke.Sort(new UporediTacke());

        List<Tacka> TackeO = new List<Tacka>();

        foreach (Tacka t in tacke)
        {
            while (TackeO.Count >= 2 && Proizvod(TackeO[TackeO.Count - 2], TackeO[TackeO.Count - 1], t) <= 0)
            {
                TackeO.RemoveAt(TackeO.Count - 1);
            }
            TackeO.Add(t);
        }
        int velicinaO = TackeO.Count;
        for (int i = tacke.Count - 2; i >= 0; i--)
        {
            while (TackeO.Count > velicinaO && Proizvod(TackeO[TackeO.Count - 2], TackeO[TackeO.Count - 1], tacke[i]) <= 0)
            {
                TackeO.RemoveAt(TackeO.Count - 1);
            }
            TackeO.Add(tacke[i]);
        }

        TackeO.RemoveAt(TackeO.Count - 1);
        return TackeO;
    }

    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        List<Tacka> tacke = new List<Tacka>();

        for (int i = 0; i < n; i++)
        {
            var koordinate = Console.ReadLine().Split().Select(long.Parse).ToArray();
            tacke.Add(new Tacka(koordinate[0], koordinate[1]));
        }

        List<Tacka> omotac = Omotac(tacke);

        long min = MnogougaoP(omotac);

        for (int i = 0; i < n; i++)
        {
            List<Tacka> noveTacke = tacke.Where((t, index) => index != i).ToList();
            List<Tacka> noviOmotac = Omotac(noveTacke);
            long povrsina = MnogougaoP(noviOmotac);
            min = Math.Min(min, povrsina);
        }

        Console.WriteLine(min);
    }
}